  "use client"
  import Image from 'next/image'
  import axios from 'axios'
  import { useEffect, useState } from 'react';
  import parse from 'html-react-parser';
  import Link from 'next/link'
  import Footer from '../../../../components/footer'
  import Header from '../../../../components/header'
  import '../../../../globals.css'
  import 'bootstrap/dist/css/bootstrap.css'
  import { useParams } from 'next/navigation'
  import Loader from '../../../../components/loader';
  import Head from 'next/head'
  import { useRouter } from 'next/router';
  import { Swiper, SwiperSlide } from 'swiper/react';
  import 'swiper/css';





  const Home = ()=>{
  const [data,setData]=useState()
  const [company,setCompany]=useState([])
  const [hasSlider,setHasSlider]=useState(false)
  const router = useRouter();

  const params = useParams()
  const [loaded,setLoaded]= useState(false)
  const [menu,setMenu]=useState([])


  async function getData(params) {
    if (params?.project) {
      const dataResponse = await axios.get('https://pixelfcty.com/api/projects?filters[name][$eq]='+params['project']+'&populate=deep')
      const data = dataResponse.data.data[0]
      console.log(data);
      if (!data) {
        router.push('/404')
      }
      setData(data)  
      const menuResponse = await axios.get('https://pixelfcty.com/api/menus?populate=deep&filters[parent]&filters[company][name][$eq]='+params.company)
      const menudata = menuResponse.data.data   
      setMenu(menudata)
      if (data) {
        if (data.attributes.slider.length!==0) {
          console.log('tooe');
          setHasSlider(true)
        } else setHasSlider(false)
      }
      console.log('pp',data);
    }

  }

  useEffect(() => { 
    getData(params)
  }, [params])

  useEffect(() => {
    if (menu.length !== 0 && data && company) {
      setLoaded(true)
    }
  }, [data,menu,company]);
    return (
      <>
          <Head>
      <title>Aljaber Holding | {params?.company} - Projects</title>
    </Head>
      {!loaded?
  
          <Loader></Loader>
      :
      <main >
        <Header iswhite={hasSlider} menu={menu} />
        <div className="container-fluid p-0 m-0 overflow-hidden">
          <div className="row ">
            <div className="col-sm-12 header-video">
              <div id="carouselExampleIndicators" className="carousel slide">
              <div className="carousel-indicators">

                {data?
                  data['attributes']['slider'].map((e,index)=>(
                    <button key={e.id} type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to={index} className="active" aria-current="true" aria-label="Slide 1"></button>
                  ))
                  :''
                }
                </div>
                <div className="carousel-inner">
                  
                {data?
                  data['attributes']['slider'].map((e,index)=>(
                    <div key={e.id} className={`carousel-item ${index==0?'active':''}`}>
                    <video  src={'https://pixelfcty.com/'+e['media']['data']['attributes']['url']}   muted autoPlay preload='true' loop className="d-block w-100">
                      Your browser does not support the video tag.
                    </video>    
                    </div>                ))
                  :''
                }


                </div>
                <button className="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
                  <span className="carousel-control-prev-icon" aria-hidden="true"></span>
                  <span className="visually-hidden">Previous</span>
                </button>
                <button className="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">
                  <span className="carousel-control-next-icon" aria-hidden="true"></span>
                  <span className="visually-hidden">Next</span>
                </button>
              </div>

            </div>
          </div>
        </div>
        <div className="container">
          <div className="row  ">
            <div className="col-md-12 ck-content">
            <Swiper
            className='mt-10'
      spaceBetween={50}
      breakpoints={{
        576: {
          slidesPerView: 1,
        },
        768: {
          slidesPerView: 3,
        },
        900:{
          slidesPerView: 3,
        }
      }}
      pagination={{ clickable: true }}
      scrollbar={{ draggable: true }}
      autoplay
      onSlideChange={() => console.log('slide change')}
      onSwiper={(swiper) => console.log(swiper)}
    >
      {
      data?
      data['attributes']['pictures']?
      data['attributes']['pictures'].map(e=>(
      <SwiperSlide key={e.id}>
        <img src={'https://pixelfcty.com'+e['picture']['data']['attributes']['url']} alt="" />
      </SwiperSlide>

      )):'':''
      
    }
    </Swiper>
              {data ?
                parse(data['attributes']['Body'])
                : '' 
              }
            </div>
          </div>
        </div>


            <Footer/>
      </main>
          }
          </>
    )
  }




  export default Home;